/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.shrines;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.curses.Injury;
import com.megacrit.cardcrawl.cards.curses.Normality;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.UpgradeShineEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardBrieflyEffect;

public class AccursedBlacksmith
extends AbstractImageEvent {
    public static final String ID = "Accursed Blacksmith";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Accursed Blacksmith");
    public static final String NAME = AccursedBlacksmith.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = AccursedBlacksmith.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = AccursedBlacksmith.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String FORGE_RESULT = DESCRIPTIONS[1];
    private static final String RUMMAGE_RESULT = DESCRIPTIONS[2];
    private static final String CURSE_RESULT1 = DESCRIPTIONS[3];
    private static final String CURSE_RESULT2 = DESCRIPTIONS[4];
    private static final String LEAVE_RESULT = DESCRIPTIONS[5];
    private int screenNum = 0;
    private boolean pickCard = false;

    public AccursedBlacksmith() {
        super(NAME, DIALOG_1, "images/events/blacksmith.jpg");
        if (AbstractDungeon.player.masterDeck.hasUpgradableCards().booleanValue()) {
            GenericEventDialog.setDialogOption(OPTIONS[0], CardLibrary.getCopy("Injury"));
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[4], true);
        }
        GenericEventDialog.setDialogOption(OPTIONS[1], CardLibrary.getCopy("Normality"));
        GenericEventDialog.setDialogOption(OPTIONS[2]);
    }

    @Override
    public void update() {
        super.update();
        if (this.pickCard && !AbstractDungeon.isScreenUp && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            AbstractDungeon.gridSelectScreen.selectedCards.get(0).upgrade();
            AbstractDungeon.player.bottledCardUpgradeCheck(AbstractDungeon.gridSelectScreen.selectedCards.get(0));
            AbstractDungeon.effectsQueue.add(new ShowCardBrieflyEffect(AbstractDungeon.gridSelectScreen.selectedCards.get(0).makeStatEquivalentCopy()));
            AbstractDungeon.topLevelEffects.add(new UpgradeShineEffect((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
            this.pickCard = false;
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        this.pickCard = true;
                        AbstractDungeon.gridSelectScreen.open(AbstractDungeon.player.masterDeck.getUpgradableCards(), 1, OPTIONS[3], true, false, false, false);
                        GenericEventDialog.updateBodyText(FORGE_RESULT);
                        this.screenNum = MathUtils.randomBoolean(0.25f) ? 1 : 2;
                        this.logMetric("Forge");
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        break;
                    }
                    case 1: {
                        this.screenNum = 2;
                        if (MathUtils.randomBoolean(0.75f)) {
                            GenericEventDialog.updateBodyText(RUMMAGE_RESULT + CURSE_RESULT2);
                            AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Normality(), Settings.WIDTH / 2, Settings.HEIGHT / 2));
                            UnlockTracker.markCardAsSeen("Normality");
                        } else {
                            GenericEventDialog.updateBodyText(RUMMAGE_RESULT);
                        }
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, AbstractDungeon.returnRandomScreenlessRelic(AbstractDungeon.returnRandomRelicTier()));
                        this.logMetric("Rummage");
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        break;
                    }
                    case 2: {
                        this.screenNum = 2;
                        this.logMetric("Ignore");
                        GenericEventDialog.updateBodyText(LEAVE_RESULT);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                    }
                }
                GenericEventDialog.clearRemainingOptions();
                break;
            }
            case 1: {
                GenericEventDialog.updateBodyText(CURSE_RESULT1);
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Injury(), Settings.WIDTH / 2, Settings.HEIGHT / 2));
                UnlockTracker.markCardAsSeen("Injury");
                switch (buttonPressed) {
                    default: 
                }
                this.screenNum = 2;
                GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

